function [prop_out] = find_imgprop(varargin)
%This function uses imreginalmax to find the local max, and imhmax to
%threashold the maximas, then calculate the centroid from the local max.
%Synatax:   [prop_out] = find_imgprop('stks',array,'theshold',0.5,'type',
%                   {'area','MeanIntensity'})
%Input:     'stks' = stacks to be processed. in a horizontal cell array
%           'threshold' = the value should be between [0 1], and only 
%               maxima above the desired level will be counted. 
%               Default = 0.1 or 10%
%           type = a cell array to cell strings each a property value.
%               Current accepted Values are:
%               'Area' = the area of the delineated regions
%               'Centroid' = Centroids of the region
%               'WeightedCentroid' = the Intensity Weighted Centroids
%               'PixelIdxList' = the pixel list in matrix indices
%               'PixelList' = the pixel list in cartesian
%               'PixelValues' = the Intensity of the pixels
%               'MaxIntensity' = the max pixel intensity in the region
%               'MinIntensity' = the min pixel intensity in the region
%               'MeanIntensity' = the mean pixel intensity of the region
%               default = MeanIntensity
%               'VoxelNumber' = the number of pixels in the puncta
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements.
%Output:    prop_out = a structure with each field named after the
%               property you are seeking.

[stks,threshold,stks_ch_names,channel_paths,type,norm] = parse(varargin);

%matlabpool
%lets get straight on calculating the local max
for i = 1:size(stks,2)
    stk_tmp = stks{1,i};        %pull out the stack for manipulation, if needed
    %check for 32bit images
    if strcmp('uint32',class(stk_tmp))
        stk_tmp = im2double2(stk_tmp);  %convert to double for use
    end
    if norm
        stk_tmp = imnorm(stk_tmp);    %normalize the image so that the top and bottom 1% reside in the top and bottom range of the bit depth.
    end
    stk_bw = false(size(stk_tmp));
    for j = 1:size(stks{1,i},3)     %make the stk Black & White
        stk_bw(:,:,j) = im2bw(stk_tmp(:,:,j),threshold);
    end
    % find all the desired image properties
    for j = 1:size(type,2)
        switch type{j}
            case {'Area','area'}
                prop_tmp = regionprops(stk_bw,'Area');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelIdxList','pixelidlist'}
                prop_tmp = regionprops(stk_bw,'PixelIdxList');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelList','pixellist'}
                prop_tmp = regionprops(stk_bw,'PixelList');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'Centroid','centroid'}
                prop_tmp = regionprops(stk_bw,'Centroid');  %find centroid
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'WeightedCentroid','weightedcentroid'}
                prop_tmp = regionprops(stk_bw,stks{1,i},'WeightedCentroid');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelValues','pixelvalues'}
                prop_tmp = regionprops(stk_bw,stks{1,i},'PixelValues');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MaxIntensity','maxintensity'}
                prop_tmp = regionprops(stk_bw,stks{1,i},'MaxIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MinIntensity','minintensity'}
                prop_tmp = regionprops(stk_bw,stks{1,i},'MinIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MeanIntensity','meanintensity'}
                prop_tmp = regionprops(stk_bw,stks{1,i},'MeanIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'Integrated','integrated'}
                lum_tmp = regionprops(stk_bw,'PixelValue');
                lum_tmp = struct2cell(lum_tmp);
                for l = 1:size(lum_tmp,2); prop_tmp{l} = sum(lum_tmp{l}); end;
            case {'VoxelNumber','voxelnumber'}
                prop_tmp = regionprops(stk_bw,'PixelIdxList');      %get the list of pixels
                for l = 1:size(prop_tmp,1); prop_tmp(l).(type{j}) = size(prop_tmp(l).PixelIdxList,1); end  %calculate the number of Pixels
                prop_tmp = rmfield(prop_tmp,'PixelIdxList');        %remove the unnecessary field
            otherwise
                error(['Unrecognized Image Property Request: ',type{j}]);
        end
        %output the structure as a matrix for easy digestion
        if isstruct(prop_tmp)
            prop_tmp = struct2cell(prop_tmp)';
        end
        prop_tmp = cell2mat(prop_tmp);
        prop_out(i).(type{j}) = prop_tmp;      %dynamic struct field output
        prop_tmp = [];
    end
end

%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end

%ok now find the points & the brightness
mkdir(channel_paths,'improp');      %create output directory
for i = 1:size(stks_ch_names,2)
    mkdir([channel_paths,'improp'],stks_ch_names{1,i}(1:end-4));
    for j = 1:size(type,2)
        data_exp = dataset(prop_out(i).(type{j}));               %to export you need to make the data a dataset.
        %now save the files
        %export(xls_exp,'XLSfile',[[channel_paths,'improp',slash,stks_ch_names{1,i}(1:end-4),slash],[type{2},'.xls']]);
        export(data_exp,'File',[[channel_paths,'improp',slash,stks_ch_names{1,i}(1:end-4),slash],[type{j},'.csv']],'delimiter',',')
        %clear data
        data_exp = [];
    end
end
%matlabpool close

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [stks,threshold,stks_ch_names,channel_paths,type,norm] = parse(input)

threshold = 0.1;    
stks = [];
type = {'MeanIntensity'};
norm = 1;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'threshold'
                    threshold = input{1,i+1};
                case 'stks'
                    stks = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%open the target images
if isempty(stks)
    prompt_box('title','Open Stacks','prompt1','Select stacks for ',...
        'prompt2','centroid processing','position','center');
    pause(0.25);
    [stks,img_range,stks_ch_names,channel_paths] = stack_gui(1);  %use cell output mode.
end
